/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nways.cfgman;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class XmlProperties
extends Properties {
    public static final String ftpChoiceDefault = "0";
    public static final int ftpChoiceDefaultInt = 0;
    public static final int ftpNumberOfChoices = 3;
    public static final int ftpChoiceOther = 3;
    public static final int ftpChoiceLocal = 0;
    public static final int ftpChoiceUs = 1;
    public static final int ftpChoiceEmea = 2;
    private static final String[][] defaults = new String[][]{{"ftpProxyHost", ""}, {"ftpFileList", "2210"}, {"ftpChoice", "0"}, {"ftpPassiveMode", "false"}, {"ftpProxyEnabled", "false"}, {"ftpDownUrl", "ftp.networking.ibm.com"}, {"ftpLocalDir", ""}, {"ftpHostName", ""}, {"ftpProxyPort", "1080"}, {"ftpRemoteDir", "ess/public/xml"}, {"ftpHostPort", "21"}, {"ftpChoices", "ftp.networking.ibm.com,ftp.lagaude.ibm.com,*"}};
    private static final String propFileName = "XmlProperties.txt";
    private static ResourceBundle myResources = null;
    private boolean loaded = false;

    public void load() throws IOException {
        File file = new File(propFileName);
        if (!file.exists()) {
            this.loadDefaults();
            this.save();
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            super.load(fileInputStream);
            this.checkProperties();
        }
        this.loaded = true;
    }

    public void save() throws IOException {
        this.checkChoices();
        File file = new File(propFileName);
        if (file.exists() && !file.canWrite()) {
            Object[] objectArray = new String[]{propFileName};
            throw new IOException(XmlProperties.messageText("noWrite", objectArray));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        super.save(fileOutputStream, XmlProperties.messageText("noEdit"));
    }

    private void loadDefaults() {
        int n = 0;
        while (n < defaults.length) {
            ((Hashtable)this).put(defaults[n][0], defaults[n][1]);
            ++n;
        }
    }

    public void setHostName(String string) throws IOException {
        if (string != null) {
            if (!this.loaded) {
                this.load();
            }
            ((Hashtable)this).put("ftpHostName", string);
            this.checkChoices();
        }
    }

    public int getFtpChoice() throws IOException {
        int n = 0;
        if (!this.loaded) {
            this.load();
        }
        String string = this.getProperty("ftpChoice", ftpChoiceDefault);
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public void setFtpChoice(int n) {
        if (n >= 0 || n <= 3) {
            ((Hashtable)this).put("ftpChoice", String.valueOf(n).trim());
        }
    }

    public boolean isFtpChoice(int n) {
        boolean bl = false;
        if (n > 0 && n <= 3) {
            bl = true;
        }
        return bl;
    }

    public void setFtpChoice(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string.trim());
        }
        catch (Exception exception) {}
        this.setFtpChoice(n);
    }

    private String[] parseChoices(String string) {
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = new String(stringTokenizer.nextToken());
            if (stringArray[n] == null || stringArray[n].equals("*")) {
                stringArray[n] = new String("");
            }
            ++n;
        }
        return stringArray;
    }

    public String[] getFtpHostNames() {
        String[] stringArray = null;
        String string = this.getProperty("ftpChoices");
        if (string != null) {
            stringArray = this.parseChoices(string);
        }
        return stringArray;
    }

    private String getFtpHostNameString(int n) {
        String string = null;
        String[] stringArray = null;
        if (n != 0 && n > 0) {
            stringArray = this.getFtpHostNames();
            if (stringArray != null && n >= stringArray.length) {
                return string;
            }
            string = stringArray[n - 1];
        }
        return string;
    }

    public String getFtpHostName(int n) {
        return this.getFtpHostNameString(n);
    }

    public String getFtpHostName(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {}
        return this.getFtpHostNameString(n);
    }

    public String getFtpHostName() {
        return this.getFtpHostName(this.getProperty("ftpChoice"));
    }

    private String getTrueFalse(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public void setProxyEnabled(boolean bl) {
        ((Hashtable)this).put("ftpProxyEnabled", this.getTrueFalse(bl));
    }

    private String findDefault(String string) {
        int n = 0;
        n = 0;
        while (n < defaults.length) {
            if (defaults[n][0].equals(string)) {
                return defaults[n][1];
            }
            ++n;
        }
        return null;
    }

    private void checkChoices() {
        String[] stringArray = null;
        String string = this.getProperty("ftpHostName");
        stringArray = this.getFtpHostNames();
        if (stringArray == null || stringArray.length != 3) {
            stringArray = this.parseChoices(this.findDefault("ftpChoices"));
        }
        if (stringArray[2] == null || stringArray[2].length() == 0 || string != null && !string.equals(stringArray[2])) {
            stringArray[2] = string != null && string.length() > 0 ? string : new String("*");
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < 3) {
                if (n != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            ((Hashtable)this).put("ftpChoices", new String(stringBuffer));
        }
    }

    public void checkProperties() {
        int n = 0;
        while (n < defaults.length) {
            String string = this.getProperty(defaults[n][0]);
            if (string == null) {
                ((Hashtable)this).put(defaults[n][0], defaults[n][1]);
            }
            ++n;
        }
    }

    private static String messageText(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("com.ibm.nways.cfgman.XmlPropertiesResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    private static String messageText(String string, Object[] objectArray) {
        String string2 = null;
        string2 = MessageFormat.format(XmlProperties.messageText(string), objectArray);
        return string2;
    }
}

